<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/caja/cCaja.php");
$oCaja = new cCaja();
require_once ("../../app/empresa/cEmpresa.php");
$oEmpresa = new cEmpresa();

require_once ("../../app/stockvalorizado/cStockvalorizado.php");
$oStockvalorizado = new  cStockvalorizado();

require_once ("../../app/preciogestion/cPreciogestion.php");
$oPreciogestion = new cPreciogestion();

require_once("../../app/producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();

$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE DEVOLUCION CLIENTE ")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("Reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  $titulos = array(
  'NOMBRE',
  'MARCA',
  'CATEGORIA',
  'PRECIO COSTO',
  'PRECIO VENTA',
  'STOCK',
  'VAL. COSTO',
  'VAL. VENTA',
  'UTILIDAD'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'REPORTE DE STOCK VALORIZADO');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	$c = $c+1;
  
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;
 

	$dtsa=$oStockvalorizado->filtrar($_GET['dat1'],$_GET['dat2'],$_GET['dat3'],$_GET['dat4'],$_GET['lim'],$_GET['punven_id'],$_GET['mar'],$_GET['cat_id']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{
				$stock=$dt1['tb_stock_num'];
				
	if($_GET['punven_id']>0){
					
					$dtspre = $oPreciogestion->mostrar_precioxpuntoventa($dt1['tb_especificacion_id'],$_GET['punven_id']);		
					$numrowspre = mysqli_num_rows($dtspre);
					
					$dtp = mysqli_fetch_array($dtspre);
					$preven = $dtp['tb_precioproductoespecificacion_preven'];
					$precos = $dtp['tb_precioproductoespecificacion_precom'];
					$preproesp_id = $dtp['tb_precioproductoespecificacion_id'];
					
					$val_precos = $precos * $stock;
					$val_preven = $preven * $stock;
					
					$valtot = $val_preven - $val_precos;
					
					
	}			
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_producto_nom'].'RAM:'.$dt1['tb_memoriaram_nom'].' M.I:'.$dt1['tb_memoriainterna_nom'])
    ->setCellValue('B'.$c, $dt1['tb_marca_nom']) 
    ->setCellValue('C'.$c, $dt1['tb_categoria_nom']) 
    ->setCellValue('D'.$c, formato_money($precos))  
    ->setCellValue('E'.$c, formato_money($preven))
    ->setCellValue('F'.$c, $dt1['tb_stock_num']) 
    ->setCellValue('G'.$c, formato_money($val_precos))   
    ->setCellValue('H'.$c, formato_money($val_preven))   
    ->setCellValue('I'.$c, formato_money($valtot));
	
	
	$totprecos+=$val_precos;
			                	$totstock+=$stock;
			                	$totpreven +=$val_preven;
			                	$totval+=$valtot;
	
    $objPHPExcel->getActiveSheet(0)->getStyle("G$c:I$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;



	
	}
	mysqli_free_result($dtsa);

    
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, formato_money($totprecos))
    ->setCellValue('H'.$c, formato_money($totpreven))
    ->setCellValue('I'.$c, formato_money($totval));
    
    
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("G$c:I$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
		

	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE STOCK VALORIZADO');
	
	$nombre_archivo="REPORTE STOCK VALORIZADO ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
$objWriter->save('php://output');
exit;
?>