<?php

// ini_set('display_errors',1);

session_start();

date_default_timezone_set('America/Lima');

if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');

require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

//ini_set('display_errors',1);
require_once ("../../config/Cado.php");
require_once ("../../app/producto/cProducto.php");
$oProducto = new cProducto();
require_once("../../app/stockgeneral/cStockgeneral.php");
$oStockgeneral = new cStockgeneral();

require_once ("../../app/formatos/formato.php"); 

$dt1=$oStockgeneral->mostrar_filtro($_GET['txt_fil_pro_dat1'],$_GET['txt_fil_pro_dat2'],$_GET['txt_fil_pro_dat3'],'',
$_GET['cmb_fil_cat_id'],$_GET['txt_fil_pro_mar']);
$num_rows= mysqli_num_rows($dt1);

// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();

// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("Reporte stock general")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");

$objPHPExcel->setActiveSheetIndex(0);
$c=1;

  $titulosColumnas = array(
  'NOMBRE',
  'COLOR',
  'MARCA',
  'CATEGORIA',
  'STOCK'
  );

  /*foreach ($nom as $val) {
      array_push($titulosColumnas, $val);
  }*/

  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

  $letracolumn = 0;
  
  for ($i=0; $i < count($titulosColumnas) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnas[$i]);
  }
  
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	
   if($num_rows>0){
	$c=$c+1;
   while($dt = mysqli_fetch_array($dt1)){								
	$stock = $dt['STOCK'];
	$total_stock += $stock;
	
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, trim($dt['tb_producto_nom']))    
    ->setCellValue('B'.$c, $dt['tb_color_nom'])
    ->setCellValue('C'.$c, $dt['tb_marca_nom'])
    ->setCellValue('D'.$c, $dt['tb_categoria_nom'])
	->setCellValue('E'.$c, $stock * 1);

    $objPHPExcel->getActiveSheet(0)->getStyle("E$c:E$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	}
   
  mysqli_free_result($dt1);
}

for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}

 $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')    
    ->setCellValue('D'.$c, '')
	->setCellValue('E'.$c, $total_stock * 1);

$objPHPExcel->getActiveSheet(0)->getStyle("E$c:E$c")->getNumberFormat()->setFormatCode('0.00');

$objPHPExcel->getActiveSheet()->setTitle('STOCK GENERAL');


$nombre_archivo="REPORTE STOCK GENERAL ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
$objWriter->save('php://output');
exit;


?>

