<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/egreso/cEgreso.php");
$oEgreso = new cEgreso();
require_once("../../app/cliente/cCliente.php");
$oCliente = new cCliente();
require_once("../../app/proveedor/cProveedor.php");
$oProveedor = new cProveedor();
$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");

// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE GENERAL EGRESO")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;

  $titulosColumnas = array(
  'FECHA.',
  'ANEXO',
  'DETALLE',
  'CAJA',
  'IMPORTE'
  );
 
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	//$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'REPORTE PRODUCTOS');
	//$objPHPExcel->getActiveSheet()->getStyle("A$c:D$c")->applyFromArray($estiloTitulos);
	
	//$c = $c+1;
  
  $letracolumn = 0;
  
	for ($i=0; $i < count($titulosColumnas) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnas[$i]);
	}
	
		$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;
 
	$dts=$oEgreso->mostrar_filtro($_GET['emp_id'],$_GET['caj_id'],$_GET['fec1'],$_GET['fec2'],$_GET['cue_id'],$_GET['subcue_id'],$_GET['doc_id'],$_GET['numdoc'],$_GET['pro_id']
	,$_GET['est'],'');
		
	while($dt1 = mysqli_fetch_array($dts)){
	    
	    
	    
	     if($dt1['modid']==20){
	
	$dts=$oCliente->mostrarUno($dt1['perid']);
	$dt = mysqli_fetch_array($dts);
	$nom=$dt['tb_cliente_nom'];
	$doc=$dt['tb_cliente_doc'];
	mysqli_free_result($dts);
	
  }else{
	if($dt1['perid']>0){
	
	$dts=$oProveedor->mostrarUno($dt1['perid']);
	$dt = mysqli_fetch_array($dts);
	$nom=$dt['tb_proveedor_nom'];
	$doc=$dt['tb_proveedor_doc'];
	mysqli_free_result($dts);
	}
	else{
		$nom = 'SALIDA S/PROVEEDOR';
		$doc = '';
	}
  }
	    
														
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_egreso_fec']))
    ->setCellValue('B'.$c, $nom.' '.$doc)  
    ->setCellValue('C'.$c, $dt1['tb_egreso_det'])
    ->setCellValue('D'.$c, $dt1['tb_caja_nom'])
    ->setCellValue('E'.$c, formato_money($dt1['tb_egreso_imp']));
	
	
	
	$tot += $dt1['tb_egreso_imp'];
	
    $objPHPExcel->getActiveSheet(0)->getStyle("E$c:E$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
	}
		
		mysqli_free_result($dts);
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')  
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, formato_money($tot));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:E$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:E$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("E$c:E$c")->getNumberFormat()->setFormatCode('0.00');
	
	$c = $c +1;
//	$objPHPExcel->getActiveSheet()->getStyle("A$c:E$c")->applyFromArray($estiloTituloColumnas);
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('Hoja 1');
	
	$nombre_archivo="REPORTE EGRESO GENERAL ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
$objWriter->save('php://output');
exit;
?>