<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/caja/cCaja.php");
$oCaja = new cCaja();
require_once ("../../app/empresa/cEmpresa.php");
$oEmpresa = new cEmpresa();
require_once ("../../app/cajageneral_cst/cCajageneral_cst.php");
$oCajageneral_cst = new cCajageneral_cst(); 
require_once("../../app/producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();

$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE CAJA CHICA ".$caj_nom.' '.$mon_abr)
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulos = array(
  'FECHA',
  'PUNTO VENTA',
  'CLIENTE',
  'DOCUMENTO',
  'VENDEDOR',
  'PRODUCTO',
  'MARCA',
  'CANTIDAD',
  'PRE. COS. TOT.',
  'PRE. VEN. TOT.',
  'GANANCIA',
  'IMEI/SERIE'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'REPORTE DE CAJA VALORIZADA');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:L$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:L$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	$c = $c+1;
  
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;
 

	$dtsa=$oCajageneral_cst->mostrar_filtrocondetalles($_GET['usu_id'],$_GET['punven_id'],$_GET['fec1'],$_GET['fec2'],$_GET['mon_id']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{ 					
		 	$can = $dt1['tb_ventadetalle_can'] * 1;
		$esp_id = $dt1['tb_especificacion_id'];

		$precos = $dt1['tb_ventadetalle_precos']; 
		$preven = $dt1['tb_ventadetalle_preuni'];
	
		$precostot = $precos * $can;
		$preventot = $preven * $can;
		$gantot = $preventot - $precostot;

		$dtses=$oProductoespecificacion->mostrar_unoinfo($esp_id);
		$num_rows= mysqli_num_rows($dtses);

		$dtes = mysqli_fetch_array($dtses);
		
		$colnom = $dtes['tb_color_nom'];
		$colcod = $dtes['tb_color_cod'];
		$memramnom = $dtes['tb_memoriaram_nom'];
		$menintnom = $dtes['tb_memoriainterna_nom'];

		$totcan += $can;
		$sum_precostot += $precostot;
		$sum_preventot += $preventot;
		$sum_gantot += $gantot;
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_venta_fec']))
    ->setCellValue('B'.$c, $dt1['tb_puntoventa_alias']) 
    ->setCellValue('C'.$c, $dt1['tb_cliente_nom']) 
    ->setCellValue('D'.$c, $dt1['tb_venta_numdoc'])  
    ->setCellValue('E'.$c, $dt1['tb_usuario_nom'])
    ->setCellValue('F'.$c, $dt1['tb_ventadetalle_nom'].'RAM:'.$memramnom.' M.I:'.$menintnom) 
    ->setCellValue('G'.$c, $dt1['tb_marca_nom'])   
     ->setCellValue('H'.$c, $can)   
    ->setCellValue('I'.$c, formato_money($precostot))
     ->setCellValue('J'.$c, formato_money($preventot))
      ->setCellValue('K'.$c, formato_money($gantot))
       ->setCellValue('L'.$c, $dt1['tb_especificacionimei_nom'].' ');
	
    $objPHPExcel->getActiveSheet(0)->getStyle("I$c:K$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	
	$totcos += $precostot;
	$totven += $preventot;
	$totgan += $gantot;
	
	
	
	}
	mysqli_free_result($dtsa);

    
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
     ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, formato_money($totcos))
    ->setCellValue('J'.$c, formato_money($totven))
    ->setCellValue('K'.$c, formato_money($totgan))
     ->setCellValue('L'.$c, '');
    
    
	$objPHPExcel->getActiveSheet()->getStyle("A$c:L$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:L$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("I$c:K$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
		

	
    for($z = 'A'; $z <= 'L'; $z++){
      $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
    }
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DE CAJA VALORIZADA');
	
	$nombre_archivo="REPORTE DE CAJA VALORIZADA ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
    $objWriter->save('php://output');
    exit;
?>