<?php
//ini_set("display_errors",1);

if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
  
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");

require_once ("../preciogestion/cPreciogestion.php");
$oPreciogestion = new cPreciogestion();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("VENTAS GENERAL")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulosColumnascompras = array(
  'NOMBRE',
  'COLOR',
  'MARCA',
  'CODBAR',
  'PRE. COSTO', 
  'PRE. VENTA'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'GESTION');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:F$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:F$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  

  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
  
		$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
		$c = $c+1;
 
		$dtc1 =$oPreciogestion->mostrar_filtro($_GET['dat1'],$_GET['dat2'],$_GET['dat3'],$_GET['dat4'],$_GET['fil_mar'],$_GET['fil_lim']);
		while($dt1 = mysqli_fetch_array($dtc1)){
		
		
			if($_GET['punven_id']>0){
					$dtspre = $oPreciogestion->mostrar_precioxpuntoventa($dt1['tb_especificacion_id'],$_GET['punven_id']);		
					$numrowspre = mysqli_num_rows($dtspre);
					
					$dtp = mysqli_fetch_array($dtspre);
					$preven = $dtp['tb_precioproductoespecificacion_preven'];
					$precos = $dtp['tb_precioproductoespecificacion_precom'];
					$preproesp_id = $dtp['tb_precioproductoespecificacion_id'];
					
				}
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_producto_nom'])
    ->setCellValue('B'.$c, $dt1['tb_color_nom'])
    ->setCellValue('C'.$c, $dt1['tb_marca_nom'])    
    ->setCellValue('D'.$c, $dt1['tb_productomarca_codbar'])
    ->setCellValue('E'.$c, formato_money($precos))
    ->setCellValue('F'.$c, formato_money($preven));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("E$c:F$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
		
		$totprecos+=$precos;
		$totpreven+=$preven;
		
		}
		
	mysqli_free_result($dtc1);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, formato_money($totprecos))
    ->setCellValue('F'.$c, formato_money($totpreven));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:F$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:F$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("E$c:F$c")->getNumberFormat()->setFormatCode('0.00');
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('GESTION PRECIOS');
	
	$nombre_archivo="PRECIOS GESTION ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
$objWriter->save('php://output');
exit;
?>