<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
 // ini_set("display_errors",1);
 
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once("../../config/Cado.php");

require_once("cCuentacobrargeneral_cst.php");
$oCuentacobrargeneral_cst = new cCuentacobrargeneral_cst();

require_once("../ingreso/cIngreso.php");
$oIngreso = new cIngreso();

$fec = date('Y-m-d');
require_once("../formatos/formato.php");
require_once("../formatos/fechas.php");
// Create new PHPExcel object

$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("VENTAS GENERAL")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);

    $c=1;
  
  $titulosColumnascompras = array(
    'VENDEDOR',
  'CLIENTE',
  'PUNTO DE VENTA',
  'TIPO',
  'NUMERO', 
  'EMISION', 
  'VENCIMIENTO', 
  'DIAS',
  'MONEDA',
  'IMPORTE',
  'SALDO'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'CUENTAS POR COBRAR');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  

  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
		
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
		
	$c = $c+1;
	
	$dtsa = $oCuentacobrargeneral_cst->cuentas_por_cobrar_reporte_agru($_GET['cli_id'],$_GET['punven_id'],$_GET['tip'],$_GET['por'],fecha_mysql($_GET['comfec1']),fecha_mysql($_GET['comfec2']),$_GET['ord']);
	$num_rows= mysqli_num_rows($dtsa);
		
	while($dta = mysqli_fetch_array($dtsa)){
	
		
		if($_GET['por']==1){
			$fe = mostrarFecha($dta['fecha']);
			$lbl = 'TOTAL DE PAGOS SEGUN FECHA DE EMISION : '.$fe;
			
		}else if($_GET['por']==2){
			$fe = mostrarFecha($dta['fechaven']);
			$lbl = 'TOTAL DE PAGOS SEGUN FECHA DE VENCIMIENTO : '.$fe;
		}
		
		$dts1 = $oCuentacobrargeneral_cst->cuentas_por_cobrar_reporte($_GET['cli_id'],$dta['tb_puntoventa_id'],$_GET['tip'],$_GET['por'],fecha_mysql($fe),$_GET['ord']);
		$num_rowsf= mysqli_num_rows($dts1);
		while($dt1 = mysqli_fetch_array($dts1))
		{
	
			$mone_id =  $dt1['tb_moneda_id'];
		
			if($i==0){
			$fecant = $dt1['tb_venta_fec'];	
			}
			
			
			$monto  =  $dt1['tb_ventapago_mon'];
			$mod_id=3;
			$est1=1;
			$est2=2;
			$saldo = 0;
			$abonos = 0;
			$dts3 = $oIngreso->mostrar_por_modulo($mod_id,$dt1['tb_ventapagoingresos_id'],$est1,$est2);
				$num_rows3= mysqli_num_rows($dts3);
				while($dt3 = mysqli_fetch_array($dts3))
				{
					$abonos+= $dt3['tb_ingreso_imp'];
				} 
				mysqli_free_result($dts3);
				$saldo = ($monto - $abonos);
			
			
			
			$total = $dt1['tb_ventapago_mon'];
			if($mone_id==1){
					$lbl_mone = 'S/ ';
					$total_soles += $total;
			}else if($mone_id==2){
					$lbl_mone = 'US$ ';
					$total_dolares += $total ;
			}
			
			if($dt1['tb_ventapago_fecven']!='0000-00-00'){
				$fecven = $dt1['tb_ventapago_fecven'];
				$dias = dias_transcurridos($fecha,$dt1['tb_ventapago_fecven']);
				if($dias<0){
					$dias = 0;
				}else{
					$dias = $dias ;
				}
			}else{
				$fecven='';
				$dias = '';
			}
					
			
		$cuenta = '';
		
		
		
		$objPHPExcel->getActiveSheet(0)
		->setCellValue('A'.$c, $dt1['tb_usuario_nom'].' '.$dt1['tb_usuario_ape'])
    ->setCellValue('B'.$c, $dt1['tb_cliente_nom'])
    ->setCellValue('C'.$c, $dt1['tb_puntoventa_alias'])    
    ->setCellValue('D'.$c, $dt1['tb_documento_abr'])
    ->setCellValue('E'.$c, $dt1['tb_venta_numdoc'])
    ->setCellValue('F'.$c, mostrarFecha($dt1['tb_venta_fec']))   
    ->setCellValue('G'.$c, mostrarFecha($fecven))
    ->setCellValue('H'.$c, $dias)
    ->setCellValue('I'.$c, $lbl_mone)
    ->setCellValue('J'.$c, formato_money($dt1['tb_ventapago_mon']))
    ->setCellValue('K'.$c, formato_money($saldo));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("J$c:K$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;	
		}		
	}
	mysqli_free_result($dtsa);
	
	
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL ')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')   
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, '')
    ->setCellValue('J'.$c, '')
    ->setCellValue('K'.$c, 'S/ '.formato_money($total_soles).' | '.'US$ '.formato_money($total_dolares) );
	
    $objPHPExcel->getActiveSheet(0)->getStyle("K$c:K$c")->getNumberFormat()->setFormatCode('0.00');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:K$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
    $c++;
		
		
		
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
$objPHPExcel->getActiveSheet()->setTitle('CUENTAS POR COBRAR');
	
$nombre_archivo="CUENTAS POR COBRAR ".date('d-m-Y H-i:s').".xlsx";
$objWriter = new Xlsx($objPHPExcel);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
$objWriter->save('php://output');
exit;
?>