<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
//ini_set("display_errors",1);
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");

require_once ("../cuentacobrada/cCuentacobrada.php");
$oCuentacobrada = new cCuentacobrada();

require_once ("../ingreso/cIngreso.php");
$oIngreso = new cIngreso();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("VENTAS GENERAL")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
    $objPHPExcel->setActiveSheetIndex(0);
    $c=1;
  
  $titulosColumnascompras = array(
  'CLIENTE',
  'PUNTO DE VENTA',
  'TIPO',
  'NUMERO', 
  'EMISION', 
  'VENCIMIENTO',
  'MONEDA',
  'IMPORTE',
  
  'MODO',
  'DIAS',
  'CUENTA',
  'OPERACION',
  'NRO. OPE.',
  'PAGADO',
  'RESPONSABLE'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'CUENTAS COBRADAS');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:O$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:O$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  

  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	
		$c = $c+1;
		
		
		$dtsa = $oCuentacobrada->cuentas_cobrada_reporte_agru($_GET['cli_id'],$_GET['punven_id'],$_GET['tip'],$_GET['por'],fecha_mysql($_GET['comfec1']),fecha_mysql($_GET['comfec2']),$_GET['ord']);
		$num_rows= mysqli_num_rows($dtsa);
		
	while($dta = mysqli_fetch_array($dtsa)){
		
		if($_GET['por']==1){
			$fe = mostrarFecha($dta['fecha']);
			$lbl = 'TOTAL DE PAGOS SEGUN FECHA DE EMISION : '.$fe;
			
		}else if($_GET['por']==2){
			$fe = mostrarFecha($dta['fechaven']);
			$lbl = 'TOTAL DE PAGOS SEGUN FECHA DE VENCIMIENTO : '.$fe;
		}
		
		
		
		$dts1 = $oCuentacobrada->cuentas_cobrada_reporte($_GET['cli_id'],$dta['tb_puntoventa_id'],$_GET['tip'],$_GET['por'],fecha_mysql($fe),$_GET['ord']);
		$num_rowsf= mysqli_num_rows($dts1);
		while($dt1 = mysqli_fetch_array($dts1))
		{
			
			$mone_id =  $dt1['tb_moneda_id'];
		
			if($i==0){
			$fecant = $dt1['tb_venta_fec'];	
			}
			
		
			$total = $dt1['tb_ingreso_imp'];
			if($mone_id==1){
					$lbl_mone = 'S/ ';
					$total_soles += $total;
			}else if($mone_id==2){
					$lbl_mone = 'US$ ';
					$total_dolares += $total ;
			}
			
			if($dt1['tb_venta_ven']!='0000-00-00'){
				$fecven = $dt1['tb_venta_ven'];
				$dias = dias_transcurridos($fecha,$dt1['tb_venta_ven']);
				if($dias<0){
					$dias = 0;
				}else{
					$dias = $dias ;
				}
			}else{
				$fecven='';
				$dias = '';
			}
					
			
			if($dt1['tb_ingreso_modpag']==1){
				$forpag = 'EFECTIVO';
			}else if($dt1['tb_ingreso_modpag']==2){
				$forpag = 'DEPOSITO';
			}else if($dt1['tb_ingreso_modpag']==3){
				$forpag = 'DETRACCION';
			}else if($dt1['tb_ingreso_modpag']==4){
				$forpag = 'TRANSFERENCIA';
			}else if($dt1['tb_ingreso_modpag']==5){
				$forpag = 'CHEQUE';
			}else if($dt1['tb_ingreso_modpag']==6){
				$forpag = 'TARJETA';
			}else if($dt1['tb_ingreso_modpag']==7){
				$forpag = 'YAPE';
			}else if($dt1['tb_ingreso_modpag']==8){
				$forpag = 'PLIN';
			}else if($dt1['tb_ingreso_modpag']==9){
				$forpag = 'NOTA DE CREDITO';
			}
			
		
		$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_cliente_nom'])
    ->setCellValue('B'.$c, $dt1['tb_puntoventa_alias'])    
    ->setCellValue('C'.$c, $dt1['tb_documento_abr'])
    ->setCellValue('D'.$c, $dt1['tb_venta_numdoc'])
    ->setCellValue('E'.$c, mostrarFecha($dt1['tb_venta_fec']))   
    ->setCellValue('F'.$c, mostrarFecha($fecven))
    ->setCellValue('G'.$c, $lbl_mone)
    ->setCellValue('H'.$c, formato_money($dt1['tb_venta_tot']))
    ->setCellValue('I'.$c, $forpag)
    ->setCellValue('J'.$c, $dias)
    ->setCellValue('K'.$c, $dt1['tb_caja_nom'].' ')
    ->setCellValue('L'.$c, mostrarFecha($dt1['tb_ingreso_fec']))
    ->setCellValue('M'.$c, $dt1['tb_ingreso_nroope'])
    ->setCellValue('N'.$c, formato_money($dt1['tb_ingreso_imp']))
    ->setCellValue('O'.$c, $dt1['tb_ingreso_cob']);
	
   // $objPHPExcel->getActiveSheet(0)->getStyle("H$c:H$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
		
		
		}
		
		
		
	}
	mysqli_free_result($dtsa);
	
	
	
		$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')   
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, '')
    ->setCellValue('J'.$c, '')
    ->setCellValue('K'.$c, '')
    ->setCellValue('L'.$c, '')
    ->setCellValue('M'.$c, '')
    ->setCellValue('N'.$c, 'S/ '.formato_money($total_soles).' | '.'US$ '.formato_money($total_dolares) )
	->setCellValue('O'.$c, '');

	$objPHPExcel->getActiveSheet()->getStyle("A$c:O$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:O$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('CUENTAS COBRADAS');
	
	$nombre_archivo="CUENTAS COBRADAS ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
    $objWriter->save('php://output');
    exit;
?>