<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");

require_once ("../compradetalle_cst/cCompradetalle_cst.php");
$oCompradetalle_cst = new cCompradetalle_cst();

require_once("../producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("COMPRAS DETALLES GENERAL")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  $titulosColumnascompras = array(
  'FECHA',
  'DOCUMENTO',
  'ALMACEN',
  'PROVEEDOR',
  'ITEM',
  'ARTICULO',
  'MARCA',
  'CANTIDAD', 
  'PRE. UNITARIO',
  'PRE. TOTAL'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'COMPRAS DETALLES');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
		$c = $c+1;
 
		$dtc1 = $oCompradetalle_cst->mostrar_filtrocondetalles($_GET['alm_id'],fecha_mysql($_GET['fec1']),fecha_mysql($_GET['fec2']));
		while($dt1 = mysqli_fetch_array($dtc1)){
		
			$can = $dt1['tb_compradetalle_can'] * 1;
		$esp_id = $dt1['tb_especificacion_id'];

		$valor_uni = $dt1['tb_compradetalle_preuni']; 
		$igv_uni = $valor_uni *0.18;
		$precos=$valor_uni+$igv_uni;
		
		
		$reg = mostrarFechaHora($dt1['tb_compra_reg']);

		$precostot = $precos * $can;
		
		$dtses=$oProductoespecificacion->mostrar_unoinfo($esp_id);
		$num_rows= mysqli_num_rows($dtses);

		$dtes = mysqli_fetch_array($dtses);
		
		$colnom = $dtes['tb_color_nom'];
		$colcod = $dtes['tb_color_cod'];
		$memramnom = $dtes['tb_memoriaram_nom'];
		$menintnom = $dtes['tb_memoriainterna_nom'];

		$sum_precos += $precos;
		$sum_precostot += $precostot;
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_compra_fec']))
    ->setCellValue('B'.$c, $dt1['tb_compra_numdoc'])    
    ->setCellValue('C'.$c, $dt1['tb_almacen_nom'])
    ->setCellValue('D'.$c, $dt1['tb_proveedor_nom'])
    ->setCellValue('E'.$c, $dt1['tb_compradetalle_nom'])
    ->setCellValue('F'.$c, $dt1['tb_producto_nom'].' '.$memramnom.' '.$menintnom)
    ->setCellValue('G'.$c, $dt1['tb_marca_nom'])   
    ->setCellValue('H'.$c, $can)
    ->setCellValue('I'.$c, formato_money($precos))
    ->setCellValue('J'.$c, formato_money($precostot));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("I$c:J$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
	
		}
		
	mysqli_free_result($dtc1);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, formato_money($sum_precos))
    ->setCellValue('J'.$c, formato_money($sum_precostot));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("I$c:J$c")->getNumberFormat()->setFormatCode('0.00');
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('COMPRA DETALLE GENERAL');
	
	$nombre_archivo="COMPRA DETALLE GENERAL ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    $objWriter->save('php://output');
    exit;
?>