<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/caja/cCaja.php");
$oCaja = new cCaja();
require_once ("../../app/empresa/cEmpresa.php");
$oEmpresa = new cEmpresa();
require_once ("../../app/cajachicageneral_cst/cCajachicageneral_cst.php");
$oCajachicageneral_cst = new cCajachicageneral_cst();

 $dtsc=$oCaja->mostrarUno($_GET['cajid']);
$dtc = mysqli_fetch_array($dtsc);
	$ban_nom=$dtc['tb_banco_nom'];
	$mon_abr=$dtc['tb_moneda_sim'];
	$caj_nom=$dtc['tb_caja_nom'];
	$edi_nom=$dtc['tb_edificio_nom'];
mysqli_free_result($dtsc); 

$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE CAJA CHICA ".$caj_nom.' '.$mon_abr)
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulos = array(
  'FECHA',
    'C. COSTO',
  'DOCUMENTO',
  'RAZON SOCIAL',
  'DETALLE',
  'N° DOCUMENTO',
  'MONTO'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'REPORTE DE CAJA CHICA '.$caj_nom.' '.$mon_abr);

	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
	
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'INGRESOS');
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('9FA8DA');
	
	$c = $c+1;
	
  
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');

	$c = $c+1;
 

	$dtsa=$oCajachicageneral_cst->mostrar_cajachica_ingreso($_GET['fec1'],$_GET['fec2'],$_GET['cajid']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{ 					
		 if($dt1['tb_cliente_id']>0){
								$nom = $dt1['tb_cliente_nom'];
								$doc = $dt1['tb_cliente_doc'];
							}
							else{
								$nom = 'INGRESO SIN CLIENTE';
								$doc = '--';
							}
							
		$toting += $dt1['tb_ingreso_imp'];
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_ingreso_fec']))
    ->setCellValue('B'.$c, $dt1['tb_puntoventa_alias']) 
    ->setCellValue('C'.$c, $doc)  
    ->setCellValue('D'.$c, $nom)
    ->setCellValue('E'.$c, $dt1['tb_ingreso_det']) 
    ->setCellValue('F'.$c, $dt1['tb_ingreso_numdoc'])    
    ->setCellValue('G'.$c, formato_money($dt1['tb_ingreso_imp']));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("F$c:F$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	}
	mysqli_free_result($dtsa);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, formato_money($toting));
    
    $objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("F$c:F$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '');
    
	$c = $c +1;
	
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'EGRESOS');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('9FA8DA');
	$c = $c+1;
	
	
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
    $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;

	
	$dtsa=$oCajachicageneral_cst->mostrar_cajachica_egreso($_GET['fec1'],$_GET['fec2'],$_GET['cajid']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{ 							
		$totegr += $dt1['tb_egreso_imp'];
		 if($dt1['tb_proveedor_id']>0){
								$nom = $dt1['tb_proveedor_nom'];
								$doc = $dt1['tb_proveedor_doc'];
							}
							else{
								$nom = 'INGRESO SIN PROVEEDOR';
								$doc = '--';
							}
							
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_egreso_fec']))
    ->setCellValue('B'.$c, $dt1['tb_puntoventa_alias']) 
    ->setCellValue('C'.$c, $doc)  
    ->setCellValue('D'.$c, $nom)
    ->setCellValue('E'.$c, $dt1['tb_egreso_det']) 
    ->setCellValue('F'.$c, $dt1['tb_egreso_numdoc'])    
    ->setCellValue('G'.$c, formato_money($dt1['tb_egreso_imp']));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("F$c:F$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	}
	mysqli_free_result($dtsa);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, formato_money($totegr));
    
    $objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:G$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
    
	$objPHPExcel->getActiveSheet(0)->getStyle("F$c:F$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
	
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '');
	$c = $c +1;
	
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'RESUMEN');
	//$objPHPExcel->getActiveSheet()->margeCells("A1:G1");
	
	
	
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('9FA8DA');
	
	$c = $c+1;
	
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, 'TOTAL INGRESOS')
    ->setCellValue('C'.$c, formato_money($toting));
    
    $objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFont()->getColor()->setRGB('FFFFFF');
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('1A237E');
    
	$objPHPExcel->getActiveSheet(0)->getStyle("C$c:C$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, 'TOTAL EGRESOS')
    ->setCellValue('C'.$c, formato_money($totegr));
    $objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFont()->getColor()->setRGB('FFFFFF');
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('B71C1C');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("C$c:C$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	$totsal = $toting - $totegr;
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, 'SALDO TOTAL')
    ->setCellValue('C'.$c, formato_money($totsal));
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("B$c:C$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FDD835');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("C$c:C$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DE CAJA CHICA');
	
	$nombre_archivo="REPORTE DE CAJA CHICA ".date('d-m-Y H-i:s').".xlsx";
    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
    $objWriter->save('php://output');
    exit;
?>