<?php

// ini_set('display_errors',1);

session_start();

date_default_timezone_set('America/Lima');

if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');

require_once dirname(__FILE__) . '/../../libreriasphp/phpexcel/Classes/PHPExcel.php';

//ini_set('display_errors',1);
require_once ("../../config/Cado.php");
require_once ("../../app/producto/cProducto.php");
$oProducto = new cProducto();
require_once("../../app/stockvalorizadocompra/cStockvalorizadocompra.php");
$oStockvalorizadocompra = new cStockvalorizadocompra();

require_once ("../../app/formatos/formato.php"); 

$emp_id = $_GET['cmb_fil_empresa_id'];
if($emp_id>0)
{
$dts1=$oStockvalorizadocompra->mostrar_filtro(fecha_mysql($_GET['txt_fil_valcom_fec1']),fecha_mysql($_GET['txt_fil_valcom_fec2']),
$_GET['txt_fil_pro_dat1'],$_GET['txt_fil_pro_dat2'],$_GET['cmb_fil_cat_id'],$_GET['txt_fil_pro_mar'],$emp_id);
$num_rows= mysqli_num_rows($dts1);

}
else
{
	$num_rows=0;
}


// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("Reporte stock valorizado compra")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");

$objPHPExcel->setActiveSheetIndex(0);
$c=1;
$estiloTituloColumnas = array(
  'font' => array(
    'name'  => 'Arial',
    'bold'  => true,
    'size'  =>8,
    'color' => array(
      'rgb' => '000000'
      )
    ),
  'fill' => array(
    'type'  => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array(
      'rgb' => 'FAFAFA')
    ),
  'borders' => array(
    'outline' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN ,
      'color' => array(
        'rgb' => '143860'
        )
      )
    ),
  'alignment' =>  array(
    'horizontal'=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical'  => PHPExcel_Style_Alignment::VERTICAL_CENTER,
    'wrap'      => TRUE
    )
  );
  $titulosColumnas = array(
  'NOMBRE',
  'MARCA',
  'CATEGORIA', 
  'CANTIDAD',
  'P. COSTO',
  'TOTAL P. COSTO'
  );

  /*foreach ($nom as $val) {
      array_push($titulosColumnas, $val);
  }*/

  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');

  $letracolumn = 0;
  
  for ($i=0; $i < count($titulosColumnas) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnas[$i]);
  }
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->applyFromArray($estiloTituloColumnas);
 	
   if($num_rows>0){
		$c=$c+1;
	while($dt1 = mysqli_fetch_array($dts1)){
			$emp_fac = $dt1['tb_empaque_fac'];
			$igv = $dt1['tb_compra_igvsub'];
			
			$can = $dt1['tb_compradetalle_can'];
			$preuni = $dt1['tb_compradetalle_preuni']* $igv;
			if($can>=$emp_fac){
									
				$preuni = $preuni / $emp_fac;
									
			}else{
				$preuni = $preuni / $emp_fac;
			}
			
			
			$totprecos = $dt1['tb_compradetalle_can'] * $preuni;
						
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_producto_nom']) 
    ->setCellValue('B'.$c, $dt1['tb_marca_nom'])
    ->setCellValue('C'.$c, $dt1['tb_categoria_nom']) 
    ->setCellValue('D'.$c, $dt1['tb_compradetalle_can'])
    ->setCellValue('E'.$c, formato_money($preuni))
    ->setCellValue('F'.$c, formato_money($totprecos));

   $objPHPExcel->getActiveSheet(0)->getStyle("D$c:F$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	 $total_can += $dt1['tb_compradetalle_can'];
	$total_preuni += $preuni;
	$total_precos += $totprecos; 
								
	}
  mysqli_free_result($dts1);
} 

for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}

 $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, $total_can) 
    ->setCellValue('E'.$c, formato_money($total_preuni))
    ->setCellValue('F'.$c, formato_money($total_precos));
	

$objPHPExcel->getActiveSheet(0)->getStyle("D$c:F$c")->getNumberFormat()->setFormatCode('0.00');

$objPHPExcel->getActiveSheet()->setTitle('STOCK VALORIZADO COMPRAS');


$nombre_archivo="REPORTE STOCK VALORIZADO COMPRAS ".date('d-m-Y H-i:s');

// Redirect output to a client’s web browser (Excel5)
//header('Content-Type: application/vnd.ms-excel');
//header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xls"');

// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$nombre_archivo.'.xlsx"');

header('Cache-Control: max-age=0');
// If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.date('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

//$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('php://output');
exit;


?>

